using System;
using System.Collections;
using System.Reflection;
using System.Threading;

using DarkStrideToolbox;


namespace DarkStride.StellarLanes.SharedDLL
{
	public class Profile
	{
		#region Properties
		private const int m_cCURRENT_PROFILE_VERSION = 5;

		private DSSortedList m_oUnassignedSkins = new DSSortedList();
		private DSSortedList m_oUnassignedModules = new DSSortedList();
		private DSSortedList m_oUnassignedChassis = new DSSortedList();
		private ComplexEntity m_oOurShip = null;
		private string m_sName = "";

		private bool m_bIsDirty = false;
		private Thread m_oSavingThread = null;
		#endregion


		public Profile()
		{
		}

		public void LoadFromFile( string sFileName )
		{
			string sFile = "";
						
			sFile = DSMisc.GetBinaryFile( sFileName );

			DeSerialize( sFile );
		}
		public void SaveToFile( bool bWaitTillSaveFinished )
		{
			lock( this )
			{
				if( m_oSavingThread == null )
				{
					if( bWaitTillSaveFinished == true )
					{
						SaveToFileThreadingly();
					}
					else
					{
						m_oSavingThread = new Thread( new ThreadStart( SaveToFileThreadingly ) );
						m_oSavingThread.Priority = System.Threading.ThreadPriority.Lowest;
						m_oSavingThread.Start();
					}
				}
			}
		}
		private void SaveToFileThreadingly()
		{
			try
			{
				//Save to a temporary file
				DSMisc.PutBinaryFile( GetTempFileName(),Serialize() );

				//Rename it
				System.IO.File.Copy( GetTempFileName(),GetFileName(),true );

				this.IsDirty = false;
			}
			catch( System.Exception oEx )
			{
				DSMisc.ShowErrors( oEx );
			}
			finally
			{
				//Signal that this save is finished
				m_oSavingThread = null;
			}			
		}
		public string GetFileName()
		{
			string sRetVal = "";
			string sFileName = "";


			sFileName = m_sName;

			sRetVal = DSMisc.GetDevelopmentAppPath() + sFileName + ".DAT";


			return( sRetVal );
		}
		public string GetTempFileName()
		{
			string sRetVal = "";
			string sFileName = "";


			sFileName = m_sName;

			sRetVal = DSMisc.GetDevelopmentAppPath() + sFileName + ".tmp";


			return( sRetVal );
		}

        public void AddItem(Item oItem)
        {
            if (Globals.ObjectIsModule(oItem) == true)
            {
                AddModule((Module)oItem);
            }
            else if (Globals.ObjectIsChassis(oItem) == true)
            {
                AddChassis((Chassis)oItem);
            }
            else if (oItem.GetType() == typeof(Skin))
            {
                this.UnassignedSkins.Add(oItem.PKey, oItem);
            }
        }
        public void AddChassis(Chassis oChassis)
        {
            if (oChassis.GetType().Name == "AIChassis")
            {
                throw new System.Exception("You've managed to get an AIChassis, how did that happen?");
            }

            if (this.UnassignedChassis.ContainsKey(oChassis.PKey) == false)
            {
                this.UnassignedChassis.Add(oChassis.PKey, oChassis);
            }
        }
        public void AddModule(Module oModule)
        {
            if (this.UnassignedModules.ContainsKey(oModule.PKey) == false)
            {
                this.UnassignedModules.Add(oModule.PKey, oModule);
            }
        }

		//This has to be done after the profile is loaded because when we load it we don't know our SocketID.
		public void UpdateProfilePKeyWithSocketID( long nSocketID )
		{
			Module oLoopModule = null;
			Chassis oLoopChassis = null;
			DSSortedList oTempList = null;
			DSSortedList oTempChassisList = null;


			if( m_oOurShip != null )
			{
				m_oOurShip.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
			}

			if( m_oUnassignedModules != null )
			{
				oTempList = new DSSortedList();

				while( m_oUnassignedModules.Count > 0 )
				{
					oLoopModule = (Module)m_oUnassignedModules.GetByIndex( 0 );
					m_oUnassignedModules.RemoveAt( 0 );

					oLoopModule.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
					oTempList.Add( oLoopModule.PKey,oLoopModule );
				}

				m_oUnassignedModules = oTempList;
			}

			if( m_oUnassignedChassis != null )
			{
				oTempList = new DSSortedList();

				while( m_oUnassignedChassis.Count > 0 )
				{
					oLoopChassis = (Chassis)m_oUnassignedChassis.GetByIndex( 0 );
					m_oUnassignedChassis.RemoveAt( 0 );

					oLoopChassis.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
					oTempList.Add( oLoopChassis.PKey,oLoopChassis );
				}

				m_oUnassignedChassis = oTempList;
			}

			//Now take care of our ship
			if( m_oOurShip != null )
			{
				oTempChassisList = new DSSortedList();
				while( m_oOurShip.Chasses.Count > 0 )
				{
					oLoopChassis = (Chassis)m_oOurShip.Chasses.GetByIndex( 0 );
					m_oOurShip.Chasses.RemoveAt( 0 );

					oLoopChassis.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
					oTempChassisList.Add( oLoopChassis.PKey,oLoopChassis );

					//Now for every module in that chassis...
					oTempList = new DSSortedList();
					while( oLoopChassis.Modules.Count > 0 )
					{
						oLoopModule = (Module)oLoopChassis.Modules.GetByIndex( 0 );
						oLoopChassis.Modules.RemoveAt( 0 );

						oLoopModule.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();
						oTempList.Add( oLoopModule.PKey,oLoopModule );
					}
					oLoopChassis.Modules = oTempList;
				}
                
				m_oOurShip.Chasses = oTempChassisList;
			}
		}
        
		public int FindOpenChassisInventoryPage()
		{
			int[] nNumItemsOnPage = new int[ 10 ];
			int nOpenPage = 0;
			int nPage = 0;
			Chassis oLoopChassis = null;
			

			//Roughly calculate where our items are
			for( int n=0 ; n<m_oUnassignedChassis.Count ; n++ )
			{
				oLoopChassis = (Chassis)m_oUnassignedChassis.GetByIndex( n );
				nPage = (int)( (double)oLoopChassis.XOffset / (double)Session.m_cEDITOR_GRID_WIDTH_CHASSIS );
				if( nPage < 10 )
				{
					nNumItemsOnPage[ nPage ]++;
				}
			}

			//Now pick an open page
			for( int nPageIdx=0 ; nPageIdx<10 ; nPageIdx++ )
			{
				if( nNumItemsOnPage[ nPageIdx ] < 8 )
				{
					nOpenPage = nPageIdx;
					break;
				}
			}


			return( nOpenPage );
		}
		public int FindOpenModuleInventoryPage()
		{
			int[] nNumItemsOnPage = new int[ 10 ];
			int nOpenPage = 0;
			int nPage = 0;
			Module oLoopModule = null;
			

			//Roughly calculate where our items are
			for( int n=0 ; n<m_oUnassignedModules.Count ; n++ )
			{
				oLoopModule = (Module)m_oUnassignedModules.GetByIndex( n );
				nPage = (int)( (double)oLoopModule.XOffset / (double)Session.m_cEDITOR_GRID_WIDTH_MODULE );
				if( nPage < 10 )
				{
					nNumItemsOnPage[ nPage ]++;
				}
			}

			//Now pick an open page
			for( int nPageIdx=0 ; nPageIdx<10 ; nPageIdx++ )
			{
				if( nNumItemsOnPage[ nPageIdx ] < 15 )
				{
					nOpenPage = nPageIdx;
					break;
				}
			}


			return( nOpenPage );
		}
        
		public string Serialize()
		{
			//int nCount = 0;
			//string sDBPKey = "";
			string sRetVal = "";
			Skin oLoopSkin = null;
			Chassis oLoopChassis = null;
			Module oLoopModule = null;
			DSSerialize oSerialize = new DSSerialize();


			//Now save our data
			oSerialize.Set( 0,m_sName );

			if( m_oOurShip != null )
			{
                oSerialize.Set(1, m_oOurShip.Serialize(null));
			}			

			oSerialize.SetList( 2 );
			for( int i=0 ; i<m_oUnassignedChassis.Count ; i++ )
			{
				oLoopChassis = (Chassis)m_oUnassignedChassis.GetByIndex( i );

				oSerialize.SetListItem( 2,oLoopChassis.GetType().Name );
                oSerialize.SetListItem(2, oLoopChassis.Serialize(null));
			}

			oSerialize.SetList( 3 );
			for( int i=0 ; i<m_oUnassignedModules.Count ; i++ )
			{
				oLoopModule = (Module)m_oUnassignedModules.GetByIndex( i );

				oSerialize.SetListItem( 3,oLoopModule.GetType().Name );
                oSerialize.SetListItem(3, oLoopModule.Serialize(null));
			}

			oSerialize.SetList( 4 );
			for( int i=0 ; i<m_oUnassignedSkins.Count ; i++ )
			{
				oLoopSkin = (Skin)m_oUnassignedSkins.GetByIndex( i );

				oSerialize.SetListItem( 4,oLoopSkin.DBSkinID );
			}

			sRetVal = oSerialize.Serialize( m_cCURRENT_PROFILE_VERSION );


			return( sRetVal );
		}
		public void DeSerialize( string sProfile )
		{
			Assembly oControlAssembly = null;
			Type oControlType = null;
			Chassis oLoopChassis = null;
			int nDBID = 0;
			int nVersion = 0;
			ArrayList oaList = null;
			Skin oNewSkin = null;
			Module oLoopModule = null;
			DSSerialize oSerialize = new DSSerialize();

try
{
			oSerialize.DeSerialize( sProfile,ref nVersion );

			if( nVersion <= 4 )
			{
				//Pitch anything less than 4 because at version 4 we made a breaking change.
				throw new System.Exception( "No user will ever see this, but it will cause the profile to not load" );
			}
			else
			{
				m_sName = oSerialize.GetString( 0 );

				if( oSerialize.Get( 1 ) != null )//.GetString( 1 ).Length > 0 )
				{
					m_oOurShip = new ComplexEntity();
					m_oOurShip.DeSerialize( null,(DSSerialize)oSerialize.Get( 1 ) );
				}

				oaList = oSerialize.GetList( 2 );
				for( int i=0 ; i<oaList.Count ; i+=2 )
				{
					//Deserialize the form into a new object... so first create the new object
					oControlAssembly = Assembly.Load("StellarLanes");//.LoadWithPartialName( "StellarLanes" );//(string)oaList[ i+1 ] );
					oControlType = oControlAssembly.GetType( "DarkStride.StellarLanes.SharedDLL." + (string)oaList[ i ] );
					//Make it!
					oLoopChassis = (Chassis)Activator.CreateInstance( oControlType,new object[]{ m_oOurShip } );
					if( oLoopChassis.Active == true )
					{
						//Now deserialize the chassis
						oLoopChassis.DeSerialize( null,(DSSerialize)oaList[ i+1 ] );
						m_oUnassignedChassis.Add( oLoopChassis.PKey,oLoopChassis );
					}
				}

				oaList = oSerialize.GetList( 3 );
				for( int i=0 ; i<oaList.Count ; i+=2 )
				{
					//Deserialize the form into a new object... so first create the new object
					oControlAssembly = Assembly.Load("StellarLanes");//.LoadWithPartialName( "StellarLanes" );//(string)oaList[ i+1 ] );
					oControlType = oControlAssembly.GetType( "DarkStride.StellarLanes.SharedDLL." + (string)oaList[ i ] );
					//Make it!
					oLoopModule = (Module)Activator.CreateInstance( oControlType,new object[]{ m_oOurShip } );
					if( oLoopModule.Active == true )
					{
						//Now deserialize the Module
						oLoopModule.DeSerialize( null,(DSSerialize)oaList[ i+1 ] );
						m_oUnassignedModules.Add( oLoopModule.PKey,oLoopModule );
					}
				}

				oaList = oSerialize.GetList( 4 );
				for( int i=0 ; i<oaList.Count ; i+=2 )
				{
					nDBID = (int)oaList[ i ];

					oNewSkin = new Skin();
					oNewSkin.DBSkinID = nDBID;
					oNewSkin.PKeyObject = Globals.Inst().PrimaryKey.GetNewPrimarykey();

					m_oUnassignedSkins.Add( oNewSkin.PKey,oNewSkin );
				}
		


				//Heal us up if we are just loading
				if( m_oOurShip != null )
				{
					m_oOurShip.RestoreToFullHealth();
				}
			}
}
catch( System.Exception oEx )
{
	DSMisc.ShowErrors( oEx );
}
		}
        

		#region Properties
		public string Name
		{
			get
			{
				return( m_sName );
			}
			set
			{
				m_sName = value;
			}
		}
		public DSSortedList UnassignedSkins
		{
			get
			{
				return( m_oUnassignedSkins );
			}
			set
			{
				m_oUnassignedSkins = value;
			}
		}
		public DSSortedList UnassignedChassis
		{
			get
			{
				return( m_oUnassignedChassis );
			}
			set
			{
				m_oUnassignedChassis = value;
			}
		}
		public DSSortedList UnassignedModules
		{
			get
			{
				return( m_oUnassignedModules );
			}
			set
			{
				m_oUnassignedModules = value;
			}
		}
		public ComplexEntity OurShip
		{
			get
			{
				return( m_oOurShip );
			}
			set
			{
				m_oOurShip = value;
			}
		}
		public bool IsDirty
		{
			get
			{
				return( m_bIsDirty );
			}
			set
			{
				m_bIsDirty = value;
			}
		}
		#endregion
	}
}
